using System;
using System.Diagnostics;
using System.Collections.Generic;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VideoVisit.Messages;
using VIMT.VideoVisit.Services.XSD;
using VIMT.VideoVisit.Services.Rest;
using System.Net.Http;

 using Logger = VRM.Integration.Servicebus.Core.Logger;
namespace VIMT.VideoVisit.Processors
{
	class VIMTTmpCreateAppointmentProcessor 
	{
	/// <summary>
	/// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,ScheduleMeeting method, Processpr.
	/// Code Generated by IMS on: 4/12/2016 6:51:29 PM
	/// Version: 2016.04.08
	/// </summary>
	/// <param name=none></param>
	/// <returns>none</returns>
        public IMessageBase Execute(VIMTTmpCreateAppointmentRequest request)
		{
			//var request = message as ScheduleMeetingRequest;
            VIMTTmpCreateAppointmentResponse response = null;
			var progressString = "Top of Processor";
			try
			{
				if (request == null)
				{
					Logger.Instance.Warn(string.Format("{0} recieved a null message", GetType().FullName));
				}
				else
				{
				#region do legacy webservice calls
					string method = "ScheduleMeetingProcessor", webService = "ScheduleMeeting";

					Stopwatch thisTimer = Stopwatch.StartNew();
					var CreateAppointmentResponse = new WriteResults();
					try
					{
						SoapLog.Current.Active = true;
                        List<Patient> newPatList = new List<Patient>();

                        foreach (var patient in request.VIMTTmpCreateAppointmentRequestDataInfo.Patients)
                        {
                            var thisPatient = new Patient
                            {
                                Id = new PersonIdentifier
                                {
                                    AssigningAuthority = patient.Id.AssigningAuthority,
                                    UniqueId = patient.Id.UniqueId
                                },
                                Name = new PersonName
                                {
                                    FirstName = patient.Name.FirstName,
                                    LastName = patient.Name.LastName
                                },
                                ContactInformation = new ContactInformation
                                {
                                    PreferredEmail = patient.ContactInformation.PreferredEmail,
                                    Mobile = patient.ContactInformation.Mobile
                                },
                                Location = new Location
                                {
                                    Type = (VIMT.VideoVisit.Services.XSD.LocationType)patient.Location.Type
                                }
                            };

                            if (patient.VistaDateTimeSpecified)
                            {
                                thisPatient.VistaDateTime = patient.VistaDateTime;
                            }

                            if (patient.ContactInformation.TimeZoneSpecified)
                            {
                                thisPatient.ContactInformation.TimeZone = patient.ContactInformation.TimeZone;
                                thisPatient.ContactInformation.TimeZoneSpecified = true;
                            }

                            if (patient.Location.Clinic != null)
                            {
                                thisPatient.Location.Clinic = new Clinic
                                {
                                    Ien = patient.Location.Clinic.Ien,
                                    Name = patient.Location.Clinic.Name
                                };
                            }

                            if (patient.Location.Facility != null)
                            {
                                thisPatient.Location.Facility = new Facility
                                {
                                    Name = patient.Location.Facility.Name,
                                    TimeZone = patient.Location.Facility.TimeZone,
                                    SiteCode = patient.Location.Facility.SiteCode
                                };
                            }

                            if (patient.VirtualMeetingRoom != null)
                            {
                                thisPatient.VirtualMeetingRoom = new VirtualMeetingRoom
                                {
                                    Conference = patient.VirtualMeetingRoom.Conference,
                                    Pin = patient.VirtualMeetingRoom.Pin,
                                    Url = patient.VirtualMeetingRoom.Url
                                };
                            }

                            newPatList.Add(thisPatient);
                        }

                        List<Provider> newProvList = new List<Provider>();

                        foreach (var item in request.VIMTTmpCreateAppointmentRequestDataInfo.Providers)
                        {
                            var thisProvider = new Provider
                            {
                                Name = new PersonName
                                {
                                    FirstName = item.Name.FirstName,
                                    LastName = item.Name.LastName
                                },
                                ContactInformation = new ContactInformation
                                {
                                    PreferredEmail = item.ContactInformation.PreferredEmail,
                                },
                                Location = new Location
                                {
                                    Type = (VIMT.VideoVisit.Services.XSD.LocationType)item.Location.Type,
                                }
                            };

                            if (item.VistaDateTimeSpecified)
                            {
                                thisProvider.VistaDateTime = item.VistaDateTime.AddMinutes(5.0);
                            }

                            if (item.ContactInformation.TimeZoneSpecified)
                            {
                                thisProvider.ContactInformation.TimeZone = item.ContactInformation.TimeZone;
                                thisProvider.ContactInformation.TimeZoneSpecified = true;
                            }



                            if (item.Location.Clinic != null)
                            {
                                thisProvider.Location.Clinic = new Clinic
                                {
                                    Ien = item.Location.Clinic.Ien,
                                    Name = item.Location.Clinic.Name
                                };
                            }

                            if (item.Location.Facility != null)
                            {
                                thisProvider.Location.Facility = new Facility
                                {
                                    Name = item.Location.Facility.Name,
                                    TimeZone = item.Location.Facility.TimeZone,
                                    SiteCode = item.Location.Facility.SiteCode
                                };
                            }

                            if (item.VirtualMeetingRoom != null)
                            {
                                thisProvider.VirtualMeetingRoom = new VirtualMeetingRoom
                                {
                                    Conference = item.VirtualMeetingRoom.Conference,
                                    Pin = item.VirtualMeetingRoom.Pin,
                                    Url = item.VirtualMeetingRoom.Url
                                };
                            }

                            newProvList.Add(thisProvider);
                        }

                        var appointmentRequest = new Appointment
                        {
                            Version = request.VIMTTmpCreateAppointmentRequestDataInfo.Version,
                            Id = request.VIMTTmpCreateAppointmentRequestDataInfo.Id,
                            SourceSystem = request.VIMTTmpCreateAppointmentRequestDataInfo.SourceSystem,
                            Patients = new Patients
                            {
                                Patient = newPatList
                            },
                            Duration = request.VIMTTmpCreateAppointmentRequestDataInfo.Duration,
                            DateTime = DateTime.Parse(request.VIMTTmpCreateAppointmentRequestDataInfo.DateTime),
                            AppointmentKind = (VIMT.VideoVisit.Services.XSD.AppointmentKind)request.VIMTTmpCreateAppointmentRequestDataInfo.AppointmentKind,
                            BookingNotes = request.VIMTTmpCreateAppointmentRequestDataInfo.BookingNotes,
                            Providers = new Providers
                            {
                                Provider = newProvList
                            }
                        };

					    if (request.VIMTTmpCreateAppointmentRequestDataInfo.SchedulingRequestTypeSpecified)
					    {
                            appointmentRequest.SchedulingRequestType = (VIMT.VideoVisit.Services.XSD.SchedulingRequestType)request.VIMTTmpCreateAppointmentRequestDataInfo.SchedulingRequestType;
					        appointmentRequest.SchedulingRequestTypeSpecified = true;
					    }

					    if (request.VIMTTmpCreateAppointmentRequestDataInfo.TypeSpecified)
					    {
                            appointmentRequest.Type = (VIMT.VideoVisit.Services.XSD.AppointmentType) request.VIMTTmpCreateAppointmentRequestDataInfo.Type;
                            appointmentRequest.TypeSpecified = true;
					    }

					    if (request.VIMTTmpCreateAppointmentRequestDataInfo.DesiredDateSpecified)
					    {
                            appointmentRequest.DesiredDate = DateTime.Parse(request.VIMTTmpCreateAppointmentRequestDataInfo.DesiredDate);
                            appointmentRequest.DesiredDateSpecified = true;
					    }
                        
                        CreateAppointmentResponse = ServiceFactory.CreateAppointment(appointmentRequest, request.VIMTTmpCreateAppointmentRequestDataInfo.SamlToken);
						thisTimer.Stop();
						LogHelper.LogInfo(request.OrganizationName, request.LogSoap, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, SoapLog.Current.Log, thisTimer.ElapsedMilliseconds);
						SoapLog.Current.Active = false;
						SoapLog.Current.ClearLog();
						LogHelper.LogTiming(request.OrganizationName, request.LogTiming, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, webService,thisTimer.ElapsedMilliseconds);
					}
					catch (Exception ex)
					{
						thisTimer.Stop();
						LogHelper.LogInfo(request.OrganizationName, request.LogSoap, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, SoapLog.Current.Log, thisTimer.ElapsedMilliseconds);
						SoapLog.Current.Active = false;
						SoapLog.Current.ClearLog();
						LogHelper.LogTiming(request.OrganizationName, request.LogTiming, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, webService,thisTimer.ElapsedMilliseconds);
                        if (response == null) response = new VIMTTmpCreateAppointmentResponse();
						var messageTest = ex.Message.ToLower();
						if (messageTest.Contains("no records"))
						{
							return response;
						}
						if (messageTest.Contains("shareexception"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						if (messageTest.Contains("access violation"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						if (messageTest.Contains("sensitive"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						LogHelper.LogError(request.OrganizationName, request.UserId, "ScheduleMeeting Processor", ex);
						response.ExceptionOccured = true;
						response.ExceptionMessage = messageTest;
						return response;
					}
						
					progressString = "Before Mapping";
					try
					{
                        response = new VIMTTmpCreateAppointmentResponse();
                        //Create Meeting Mapping 
                        #region  Create Meeting Mapping
                        var VIMTTmpCreateAppointmentResponseData  = new VIMTTmpCreateAppointmentResponseData();
					    VIMTTmpCreateAppointmentResponseData.HttpStatusCode = "OK";
                        VIMTTmpCreateAppointmentResponseData.VIMTTmpWriteResults = new VIMTTmpWriteResults();
                        VIMTTmpCreateAppointmentResponseData.VIMTTmpWriteResults.VIMTTmpWriteResult = new VIMTTmpWriteResult[CreateAppointmentResponse.WriteResult.Count];
					    var index = 0;
                        foreach (var result in CreateAppointmentResponse.WriteResult)
                        {
                            var writeResult = new VIMTTmpWriteResult
					        {
                                PersonId = result.PersonId,
                                FacilityCode = result.FacilityCode,
                                FacilityName = result.FacilityName,
                                ClinicIen = result.ClinicIEN,
                                ClinicName = result.ClinicName,
                                DateTime = result.DateTime,
                                VistaStatus = (VIMT.VideoVisit.Messages.VIMTTmpVistaStatus)Enum.Parse(typeof(VIMT.VideoVisit.Messages.VIMTTmpVistaStatus), result.VistaStatus.ToString(), true),
                                Reason = result.Reason
					        };
                            if (result.Name != null) writeResult.Name = new VIMTTmpPersonName { FirstName = result.Name.FirstName, LastName = result.Name.LastName };
                            VIMTTmpCreateAppointmentResponseData.VIMTTmpWriteResults.VIMTTmpWriteResult.SetValue(writeResult, index);
                            index++;
                        }
                        response.VIMTTmpCreateAppointmentResponseDataInfo = VIMTTmpCreateAppointmentResponseData;
						
						#endregion
					}
					catch (Exception ex)
					{
					    Logger.Instance.Error(string.Format("Error in VVS CreateAppointment Processor EC: Error is: {0}", ex.Message));
                        LogHelper.LogError(request.OrganizationName, request.UserId, "CreateAppointment Processor, Progess:" + progressString, ex);
                     if (response == null) response = new VIMTTmpCreateAppointmentResponse();
					response.ExceptionOccured = true;
					response.ExceptionMessage = ex.Message;
					return response;
					}
				#endregion
			}
			    Logger.Instance.Debug("Completed VVS CreateAppointment Processor EC");
                return response;
			}
			catch (Exception ex)
			{
			    Logger.Instance.Error(string.Format("Error in VVS CreateAppointment Processor EC: Error is: {0}", ex.Message));
                LogHelper.LogError(request.OrganizationName, request.UserId, "CreateAppointment Processor, Progess:" + progressString, ex);
                if (response == null) response = new VIMTTmpCreateAppointmentResponse();
				response.ExceptionOccured = true;
				response.ExceptionMessage = ex.Message;
				return response;
			}
		}
	}
}
